/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.requirement;

import com.agricraft.agricraft.api.crop.AgriCrop;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public interface AgriGrowthResponse {
    public static final AgriGrowthResponse FERTILE = new AgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return true;
        }

        @Override
        public boolean isLethal() {
            return false;
        }

        public String toString() {
            return "AgriGrowthResponse{FERTILE}";
        }
    };
    public static final AgriGrowthResponse INFERTILE = new AgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return false;
        }

        @Override
        public boolean isLethal() {
            return false;
        }

        public String toString() {
            return "AgriGrowthResponse{INFERTILE}";
        }
    };
    public static final AgriGrowthResponse LETHAL = new AgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return false;
        }

        @Override
        public boolean isLethal() {
            return true;
        }

        public String toString() {
            return "AgriGrowthResponse{LETHAL}";
        }
    };
    public static final AgriGrowthResponse KILL_IT_WITH_FIRE = new AgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return false;
        }

        @Override
        public boolean isLethal() {
            return true;
        }

        @Override
        public boolean isInstantKill() {
            return true;
        }

        @Override
        public void onPlantKilled(AgriCrop crop) {
            class_1937 world = crop.method_10997();
            if (world instanceof class_3218) {
                double x = (double)crop.method_11016().method_10263() + 0.5;
                double y = (double)crop.method_11016().method_10264() + 0.5;
                double z = (double)crop.method_11016().method_10260() + 0.5;
                for (int i = 0; i < 3; ++i) {
                    world.method_8406((class_2394)class_2398.field_11237, x + 0.25 * world.method_8409().method_43058(), y, z + 0.25 * world.method_8409().method_43058(), 1.0, 0.0, 1.0);
                }
                world.method_43128(null, x, y, z, class_3417.field_19198, class_3419.field_15245, 0.2f + world.method_8409().method_43057() * 0.2f, 0.9f + world.method_8409().method_43057() * 0.15f);
            }
        }

        public String toString() {
            return "AgriGrowthResponse{KILL_IT_WITH_FIRE}";
        }
    };

    public boolean isFertile();

    public boolean isLethal();

    default public boolean isInstantKill() {
        return false;
    }

    default public void onPlantKilled(AgriCrop crop) {
    }

    default public int priority() {
        if (this.isInstantKill()) {
            return 3;
        }
        if (this.isLethal()) {
            return 2;
        }
        if (!this.isFertile()) {
            return 1;
        }
        return 0;
    }
}

